//Original uploaded to Shadertoy.com by mpcomplete :'Hypnobar.'

uniform float u_Elapsed;
uniform vec2 u_WindowSize;

#define iGlobalTime u_Elapsed 
#define iResolution u_WindowSize


float SIZE = 0.025;
float GAP = 1.2;

void main(void)
{
	vec2 uv = gl_FragCoord.xy / iResolution.xy;
    float t = 0.5+0.5*sin(iGlobalTime);
    uv.y += 0.1*sin((uv.x / (GAP*SIZE))*1.0 + iGlobalTime);
    vec2 dot = step(mod(uv, GAP*SIZE), vec2(SIZE));
    float inSquare = dot.x*dot.y;
    gl_FragColor = inSquare*vec4(uv,t,1.0);
}
